<?php
/* --------------------------------------------------------------
   remove_admin_access_from_non_admins.php 2023-11-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

/** @var DatabaseModel $this */
/** @var int $t_success */

// Selects all the customers that are not admin (customer_group = 0), but still have an entry in the `admin_access_users` table
$sql    = "SELECT customer_id FROM admin_access_users aau LEFT JOIN customers c ON c.customers_id = aau.customer_id WHERE c.customers_status IS NULL OR c.customers_status != 0;";
$result = $this->query($sql, true);

if ($result->num_rows > 0) {
    $rows = $result->fetch_all(MYSQLI_ASSOC);
    $customerIds = array_map(static fn($customer) => (int)$customer['customer_id'], $rows);
    
    $deleteQuery = "DELETE FROM `admin_access_users` WHERE customer_id IN (" . implode(',', $customerIds) . ");";
    $t_success &= $this->query($deleteQuery, true);
}